/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.util;

import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.calldorado.sdk.CalldoradoApplication;
import com.calldorado.sdk.util.EmergencyNumbersKt;
import io.michaelrocks.libphonenumber.android.PhoneNumberUtil;
import io.michaelrocks.libphonenumber.android.Phonenumber;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\f"}, d2={"Lcom/calldorado/sdk/util/EmergencyNumbers;", "", "()V", "getNumberFromIntent", "", "intent", "Landroid/content/Intent;", "isEmergencyNumber", "", "context", "Landroid/content/Context;", "number", "sdk_release"})
@StabilityInferred(parameters=0)
public final class EmergencyNumbers {
    @NotNull
    public static final EmergencyNumbers INSTANCE = new EmergencyNumbers();
    public static final int $stable;

    private EmergencyNumbers() {
    }

    public final boolean isEmergencyNumber(@NotNull Context context, @Nullable String number) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            CharSequence charSequence = number;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return false;
            }
            PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.createInstance((Context)context);
            Phonenumber.PhoneNumber protoNumber = null;
            try {
                String string2;
                Object object = context.getSystemService("phone");
                TelephonyManager telephonyManager = object instanceof TelephonyManager ? (TelephonyManager)object : null;
                Object object2 = telephonyManager;
                if (object2 != null && (object2 = object2.getSimCountryIso()) != null) {
                    String string3 = ((String)object2).toUpperCase(Locale.ROOT);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                } else {
                    string2 = null;
                }
                String region = string2;
                protoNumber = phoneNumberUtil.parse((CharSequence)number, region);
            }
            catch (Exception exception) {
                return false;
            }
            Phonenumber.PhoneNumber phoneNumber = protoNumber;
            if (phoneNumber != null) {
                Object[] emergencyNumberEntry;
                Phonenumber.PhoneNumber it = phoneNumber;
                boolean bl = false;
                String countryCode = String.valueOf(it.getCountryCode());
                String baseNumber = String.valueOf(it.getNationalNumber());
                if (emergencyNumberEntry != null) {
                    Object[] entry = emergencyNumberEntry = EmergencyNumbersKt.getEmergencyNumberMap().get(countryCode);
                    boolean bl2 = false;
                    if (ArraysKt.contains((Object[])entry, (Object)baseNumber)) {
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)"isEmergencyNumber", (String)("isEmergencyNumber: exception = " + e));
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)String.valueOf(e.getMessage()))};
            CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "isEmergencyNumber Exception", "CDO_STAT_V7_ERROR", MapsKt.hashMapOf((Pair[])pairArray), 0.0, 8, null);
            return false;
        }
    }

    @Nullable
    public final String getNumberFromIntent(@Nullable Intent intent) {
        String string2;
        try {
            Intent intent2 = intent;
            Intent i = (Intent)(intent2 != null && (intent2 = intent2.getExtras()) != null ? intent2.get("android.intent.extra.INTENT") : null);
            Intent intent3 = i;
            string2 = intent3 != null && (intent3 = intent3.getExtras()) != null ? intent3.getString("incoming_number") : null;
        }
        catch (Exception e) {
            Log.d((String)"getNumberFromIntent", (String)("getNumberFromIntent: exception = " + e));
            string2 = "";
        }
        return string2;
    }
}

