/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.util;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyCallback;
import android.telephony.TelephonyDisplayInfo;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.DateUtils;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.calldorado.sdk.CalldoradoApplication;
import com.calldorado.sdk.R;
import com.calldorado.sdk.logging.CLog;
import com.calldorado.sdk.preferences.PreferencesManager;
import com.calldorado.sdk.util.AppVersionData;
import com.calldorado.sdk.util.ConnectionSpeedData;
import com.calldorado.sdk.util.FunctionsKt;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0010\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a1\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042!\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00060\b\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0006\u0010\u0012\u001a\u00020\r\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000f\u001a\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000f\u001a\u000e\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\r\u001a\u000e\u0010!\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\"\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\r\u001a\u0016\u0010$\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&\u001a\u000e\u0010'\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010(\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020+H\u0003\u001a\u0006\u0010,\u001a\u00020\u0001\u001a\b\u0010-\u001a\u00020\u0001H\u0002\u001a\b\u0010.\u001a\u00020\u0001H\u0007\u001a\u001b\u0010/\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0003\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100\u001a\u000e\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020&\u001a\u000e\u00103\u001a\u00020\u00062\u0006\u00102\u001a\u00020&\u001a\u000e\u00104\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\b\u00105\u001a\u00020\u0001H\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00066"}, d2={"canDoManualSearch", "", "canForegroundServiceStart", "context", "Landroid/content/Context;", "checkFor5GNetwork", "", "result", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "is5GNetwork", "formatSeconds", "", "totalTime", "", "getAppVersionData", "Lcom/calldorado/sdk/util/AppVersionData;", "getCDMACountryIso", "getConnectionSpeed", "Lcom/calldorado/sdk/util/ConnectionSpeedData;", "getCountry", "getDeviceCountryCode", "getDoraApiToken", "getDoraAppKey", "getLegacyClid", "getOptinVersion", "getPrettyDate", "date", "getPrettyTime", "hasCallLog", "hasManifestPermissionDeclared", "permissionName", "hasOverlayPermission", "hasPermission", "permission", "isCCPAUser", "preferencesManager", "Lcom/calldorado/sdk/preferences/PreferencesManager;", "isFirebaseEventReceiverPresent", "isNewInstall", "isOverrideNetworkType5G", "telephonyDisplayInfo", "Landroid/telephony/TelephonyDisplayInfo;", "isTestDevice", "isWaterfallTest", "needOverlay", "requestAdvertiserId", "(Landroid/content/Context;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendFirstHandshakeEventIfNeeded", "mPreferencesManager", "sendFirstSdkCallIfNeeded", "sendToAppSettings", "testDeviceOn", "sdk_release"})
public final class FunctionsKt {
    public static final boolean hasPermission(@NotNull Context context, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0;
    }

    public static final boolean hasCallLog(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT < 28 || FunctionsKt.hasPermission(context, "android.permission.READ_CALL_LOG");
    }

    public static final boolean hasOverlayPermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT < 23 || Settings.canDrawOverlays((Context)context);
    }

    public static final boolean canForegroundServiceStart(@Nullable Context context) {
        if (context == null) {
            return false;
        }
        return Build.VERSION.SDK_INT < 31 || FunctionsKt.hasOverlayPermission(context);
    }

    public static final boolean hasManifestPermissionDeclared(@NotNull Context context, @NotNull String permissionName) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)permissionName, (String)"permissionName");
            PackageInfo packageInfo = null;
            try {
                packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            PackageInfo packageInfo2 = packageInfo;
            if (packageInfo2 == null) break block4;
            PackageInfo it = packageInfo2;
            boolean bl = false;
            String[] requestedPermissions = it.requestedPermissions;
            if (requestedPermissions != null) {
                for (String permission : requestedPermissions) {
                    if (!Intrinsics.areEqual((Object)permission, (Object)permissionName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @ChecksSdkIntAtLeast(api=29)
    public static final boolean needOverlay() {
        return Build.VERSION.SDK_INT >= 29;
    }

    @NotNull
    public static final String getOptinVersion(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int resStringId = context.getResources().getIdentifier("OPTIN_VERSION_ID", "string", context.getPackageName());
        String optinVersion = "";
        if (resStringId != 0) {
            String string2 = context.getResources().getString(resStringId);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.resources.getString(resStringId)");
            optinVersion = string2;
        }
        return optinVersion;
    }

    @NotNull
    public static final AppVersionData getAppVersionData(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object appVersion = "";
        Object appVersionCode = "";
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            appVersion = pInfo.versionName;
            appVersionCode = "" + pInfo.versionCode;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new AppVersionData((String)appVersion, (String)appVersionCode);
    }

    @NotNull
    public static final String getCountry(@NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            String string3;
            block5: {
                block4: {
                    Object object = context.getApplicationContext().getSystemService("phone");
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
                    TelephonyManager tel = (TelephonyManager)object;
                    string3 = tel.getNetworkCountryIso();
                    if (string3 == null) break block4;
                    String string4 = string3;
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                    String string5 = string4.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
                    string3 = string5;
                    if (string5 != null) break block5;
                }
                string3 = "";
            }
            string2 = string3;
        }
        catch (Exception e) {
            string2 = "";
        }
        String countryCode = string2;
        return countryCode;
    }

    @NotNull
    public static final ConnectionSpeedData getConnectionSpeed(@NotNull Context context) {
        ConnectionSpeedData connectionSpeedData;
        block1: {
            NetworkCapabilities networkCapabilities;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            connectionSpeedData = new ConnectionSpeedData(0, 0, 3, null);
            if (Build.VERSION.SDK_INT < 23) break block1;
            Object object = context.getSystemService("connectivity");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
            ConnectivityManager connectivityManager = (ConnectivityManager)object;
            NetworkCapabilities networkCapabilities2 = networkCapabilities = connectivityManager.getNetworkCapabilities(connectivityManager.getActiveNetwork());
            if (networkCapabilities2 != null) {
                NetworkCapabilities it = networkCapabilities2;
                boolean bl = false;
                connectionSpeedData.setDownSpeed(it.getLinkDownstreamBandwidthKbps());
                connectionSpeedData.setUpSpeed(it.getLinkUpstreamBandwidthKbps());
            }
        }
        return connectionSpeedData;
    }

    @Nullable
    public static final String getDoraApiToken(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager.g\u2026r.GET_META_DATA\n        )");
            ApplicationInfo ai = applicationInfo;
            Bundle bundle = ai.metaData;
            return bundle.getString("com.calldorado.apiToken");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Nullable
    public static final String getDoraAppKey(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager.g\u2026r.GET_META_DATA\n        )");
            ApplicationInfo ai = applicationInfo;
            Bundle bundle = ai.metaData;
            return bundle.getString("com.calldorado.appKey");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @NotNull
    public static final String formatSeconds(long totalTime) {
        String string2;
        int minutesInHour = 60;
        int secsInMinute = 60;
        int secs = (int)(totalTime % (long)secsInMinute);
        int minutes = (int)(totalTime % (long)(minutesInHour * secsInMinute) / (long)minutesInHour);
        int hours = (int)(totalTime / (long)(minutesInHour * secsInMinute));
        if (hours > 0) {
            String string3 = "%02d:%02d";
            Object[] objectArray = new Object[]{hours, minutes};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        } else {
            String string5 = "%02d:%02d";
            Object[] objectArray = new Object[]{minutes, secs};
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
        }
        return string2;
    }

    public static final void sendToAppSettings(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent myAppSettings = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.parse((String)("package:" + context.getPackageName())));
        myAppSettings.addCategory("android.intent.category.DEFAULT");
        myAppSettings.setFlags(0x800000);
        context.startActivity(myAppSettings);
    }

    @NotNull
    public static final String getPrettyDate(@NotNull Context context, long date) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Calendar curCalendar = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date);
        if (calendar.get(6) == curCalendar.get(6)) {
            String string2 = context.getString(R.string.date_string_today);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.string.date_string_today)");
            return string2;
        }
        if (calendar.get(6) - 1 == curCalendar.get(6)) {
            String string3 = context.getString(R.string.date_string_tomorrow);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.date_string_tomorrow)");
            return string3;
        }
        String string4 = DateUtils.formatDateTime((Context)context, (long)date, (int)98458);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"formatDateTime(\n        \u2026Utils.FORMAT_24HOUR\n    )");
        return string4;
    }

    @NotNull
    public static final String getPrettyTime(long date) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm", Locale.getDefault());
        Date now = new Date();
        now.setTime(date);
        String string2 = sdf.format(now);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdf.format(now)");
        return string2;
    }

    public static final boolean isNewInstall(@NotNull Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            long firstInstallTime = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime;
            long lastUpdateTime = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
            bl = firstInstallTime == lastUpdateTime;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        return bl;
    }

    @NotNull
    public static final String getLegacyClid(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String oldClidPrefName = "cdo_config_in_app";
        String oldClidKey = "packageInfo";
        String legacyClid = null;
        legacyClid = "";
        try {
            String packageInfoStr;
            SharedPreferences sharedPreferences = context.getSharedPreferences(oldClidPrefName, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026me, Context.MODE_PRIVATE)");
            SharedPreferences sharedPreferences2 = sharedPreferences;
            String string2 = packageInfoStr = sharedPreferences2.getString(oldClidKey, "");
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                String separator = "\"clid\":\"";
                int sepPos = StringsKt.indexOf$default((CharSequence)packageInfoStr, (String)separator, (int)0, (boolean)false, (int)6, null);
                String string3 = packageInfoStr.substring(sepPos + separator.length());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                String clid = string3;
                String string4 = clid.substring(0, StringsKt.indexOf$default((CharSequence)clid, (String)"\"", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                clid = string4;
                CLog.d("Migration", "legacy clid = " + clid);
                legacyClid = clid;
            }
        }
        catch (Exception e) {
            CLog.d("Migration", "getLegacyClid: error " + e);
        }
        return legacyClid;
    }

    public static final boolean isFirebaseEventReceiverPresent(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("custom_firebase_event");
        List list = packageManager.queryBroadcastReceivers(intent, 128);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageManager.queryBroa\u2026ageManager.GET_META_DATA)");
        List resolveInfo = list;
        return resolveInfo.size() > 0;
    }

    public static final void sendFirstHandshakeEventIfNeeded(@NotNull PreferencesManager mPreferencesManager) {
        Intrinsics.checkNotNullParameter((Object)mPreferencesManager, (String)"mPreferencesManager");
        if (!mPreferencesManager.getValue("wasFirstHandshakeReported", false)) {
            mPreferencesManager.saveValue("wasFirstHandshakeReported", true);
            CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "sdk_first_handshake", "OPTIN", null, 0.0, 12, null);
        }
    }

    public static final void sendFirstSdkCallIfNeeded(@NotNull PreferencesManager mPreferencesManager) {
        Intrinsics.checkNotNullParameter((Object)mPreferencesManager, (String)"mPreferencesManager");
        if (!mPreferencesManager.getValue("wasFirstSdkStartReported", false)) {
            mPreferencesManager.saveValue("wasFirstSdkStartReported", true);
            CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "first_sdk_start_call", "OPTIN", null, 0.0, 12, null);
        }
    }

    @Nullable
    public static final Object requestAdvertiserId(@NotNull Context context, @NotNull Continuation<? super String> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(context, null){
            int label;
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.$context);
                            Intrinsics.checkNotNullExpressionValue((Object)info, (String)"getAdvertisingIdInfo(context)");
                            AdvertisingIdClient.Info adInfo = info;
                            return adInfo.getId();
                        }
                        catch (Exception exception) {
                            return "";
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final boolean isTestDevice() {
        return FunctionsKt.isWaterfallTest() || FunctionsKt.testDeviceOn();
    }

    private static final boolean isWaterfallTest() {
        return CalldoradoApplication.Companion.getDoraConfig("cdo_ads", "test", false);
    }

    private static final boolean testDeviceOn() {
        return CalldoradoApplication.Companion.getDoraConfig("cdo_ads", "test_device", false);
    }

    public static final boolean canDoManualSearch() {
        boolean bl;
        long currentTimeMin = System.currentTimeMillis() / (long)60000;
        Lazy preferencesManager$delegate = LazyKt.lazy((Function0)canDoManualSearch.preferencesManager.2.INSTANCE);
        long firstSearchTime = FunctionsKt.canDoManualSearch$lambda-3((Lazy<PreferencesManager>)preferencesManager$delegate).getValue("manualSearchFirstTime", 0L);
        long secondSearchTime = FunctionsKt.canDoManualSearch$lambda-3((Lazy<PreferencesManager>)preferencesManager$delegate).getValue("manualSearchSecondTime", 0L);
        if (secondSearchTime == currentTimeMin) {
            bl = false;
        } else if (firstSearchTime == currentTimeMin) {
            FunctionsKt.canDoManualSearch$lambda-3((Lazy<PreferencesManager>)preferencesManager$delegate).saveValue("manualSearchSecondTime", currentTimeMin);
            bl = true;
        } else {
            FunctionsKt.canDoManualSearch$lambda-3((Lazy<PreferencesManager>)preferencesManager$delegate).saveValue("manualSearchFirstTime", currentTimeMin);
            bl = true;
        }
        return bl;
    }

    public static final void checkFor5GNetwork(@NotNull Context context, @NotNull Function1<? super Boolean, Unit> result) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            try {
                Object object = context.getSystemService("phone");
                TelephonyManager telephonyManager = object instanceof TelephonyManager ? (TelephonyManager)object : null;
                if (telephonyManager == null) {
                    result.invoke((Object)false);
                    return;
                }
                TelephonyManager telephonyManager2 = telephonyManager;
                if (Build.VERSION.SDK_INT >= 31) {
                    telephonyManager2.registerTelephonyCallback(context.getMainExecutor(), (TelephonyCallback)new TelephonyCallback.DisplayInfoListener(telephonyManager2, context, result){
                        final /* synthetic */ TelephonyManager $telephonyManager;
                        final /* synthetic */ Context $context;
                        final /* synthetic */ Function1<Boolean, Unit> $result;
                        {
                            this.$telephonyManager = $telephonyManager;
                            this.$context = $context;
                            this.$result = $result;
                        }

                        public void onDisplayInfoChanged(@NotNull TelephonyDisplayInfo telephonyDisplayInfo) {
                            Intrinsics.checkNotNullParameter((Object)telephonyDisplayInfo, (String)"telephonyDisplayInfo");
                            this.$telephonyManager.unregisterTelephonyCallback((TelephonyCallback)this);
                            if (ActivityCompat.checkSelfPermission((Context)this.$context, (String)"android.permission.READ_PHONE_STATE") != 0) {
                                this.$result.invoke((Object)false);
                                return;
                            }
                            this.$result.invoke((Object)(FunctionsKt.access$isOverrideNetworkType5G(telephonyDisplayInfo) && this.$telephonyManager.isDataEnabled() ? 1 : 0));
                        }
                    });
                    break block5;
                }
                if (Build.VERSION.SDK_INT == 30) {
                    telephonyManager2.listen(new PhoneStateListener(telephonyManager2, context, result){
                        final /* synthetic */ TelephonyManager $telephonyManager;
                        final /* synthetic */ Context $context;
                        final /* synthetic */ Function1<Boolean, Unit> $result;
                        {
                            this.$telephonyManager = $telephonyManager;
                            this.$context = $context;
                            this.$result = $result;
                        }

                        @Deprecated(message="Deprecated in Java")
                        public void onDisplayInfoChanged(@NotNull TelephonyDisplayInfo telephonyDisplayInfo) {
                            Intrinsics.checkNotNullParameter((Object)telephonyDisplayInfo, (String)"telephonyDisplayInfo");
                            this.$telephonyManager.listen((PhoneStateListener)this, 0);
                            if (ActivityCompat.checkSelfPermission((Context)this.$context, (String)"android.permission.READ_PHONE_STATE") != 0) {
                                this.$result.invoke((Object)false);
                                return;
                            }
                            super.onDisplayInfoChanged(telephonyDisplayInfo);
                            this.$result.invoke((Object)(FunctionsKt.access$isOverrideNetworkType5G(telephonyDisplayInfo) && this.$telephonyManager.isDataEnabled() ? 1 : 0));
                        }
                    }, 0x100000);
                    break block5;
                }
                result.invoke((Object)false);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                result.invoke((Object)false);
                return;
            }
        }
    }

    public static final boolean isCCPAUser(@NotNull Context context, @NotNull PreferencesManager preferencesManager2) {
        boolean isCCPAUser;
        block4: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)preferencesManager2, (String)"preferencesManager");
                if (preferencesManager2.getValue("isDebugCCPAUser", false)) {
                    return true;
                }
                isCCPAUser = false;
                String string2 = FunctionsKt.getDeviceCountryCode(context);
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"us", (boolean)false, (int)2, null)) break block4;
                TimeZone tz = TimeZone.getDefault();
                String string4 = tz.getID();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"tz.id");
                if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"Los_Angeles", (boolean)false, (int)2, null)) break block5;
                String string5 = tz.getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"tz.displayName");
                if (!StringsKt.contains$default((CharSequence)string5, (CharSequence)"Pacific Standard Time", (boolean)false, (int)2, null)) break block4;
            }
            isCCPAUser = true;
        }
        return isCCPAUser;
    }

    @NotNull
    public static final String getDeviceCountryCode(@NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String countryCode = null;
        Object object = context.getSystemService("phone");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
        TelephonyManager tm = (TelephonyManager)object;
        countryCode = tm.getSimCountryIso();
        if (countryCode != null && countryCode.length() == 2) {
            String string3 = countryCode;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string4 = string3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
            return string4;
        }
        String string5 = countryCode = tm.getPhoneType() == 2 ? FunctionsKt.getCDMACountryIso() : tm.getNetworkCountryIso();
        if (countryCode != null && countryCode.length() == 2) {
            String string6 = countryCode;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string7 = string6.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toLowerCase(locale)");
            return string7;
        }
        String string8 = countryCode = Build.VERSION.SDK_INT >= 24 ? context.getResources().getConfiguration().getLocales().get(0).getCountry() : context.getResources().getConfiguration().locale.getCountry();
        if (countryCode != null && countryCode.length() == 2) {
            String string9 = countryCode;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string10 = string9.toLowerCase(locale);
            string2 = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public static final String getCDMACountryIso() {
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Class[] classArray = new Class[]{String.class};
            Method get = systemProperties.getMethod("get", classArray);
            Object[] objectArray = new Object[]{"ro.cdma.home.operator.numeric"};
            Object object = get.invoke(systemProperties, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String homeOperator = (String)object;
            int mcc = 0;
            if (!TextUtils.isEmpty((CharSequence)homeOperator) && homeOperator.length() >= 3) {
                String string2 = homeOperator.substring(0, 3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                mcc = Integer.parseInt(string2);
            }
            switch (mcc) {
                case 330: {
                    return "PR";
                }
                case 310: {
                    return "US";
                }
                case 311: {
                    return "US";
                }
                case 312: {
                    return "US";
                }
                case 316: {
                    return "US";
                }
                case 283: {
                    return "AM";
                }
                case 460: {
                    return "CN";
                }
                case 455: {
                    return "MO";
                }
                case 414: {
                    return "MM";
                }
                case 619: {
                    return "SL";
                }
                case 450: {
                    return "KR";
                }
                case 634: {
                    return "SD";
                }
                case 434: {
                    return "UZ";
                }
                case 232: {
                    return "AT";
                }
                case 204: {
                    return "NL";
                }
                case 262: {
                    return "DE";
                }
                case 247: {
                    return "LV";
                }
                case 255: {
                    return "UA";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @RequiresApi(value=30)
    private static final boolean isOverrideNetworkType5G(TelephonyDisplayInfo telephonyDisplayInfo) {
        int overrideNetworkType = telephonyDisplayInfo.getOverrideNetworkType();
        return overrideNetworkType == 2 || overrideNetworkType == 3 || overrideNetworkType == 4;
    }

    private static final PreferencesManager canDoManualSearch$lambda-3(Lazy<PreferencesManager> $preferencesManager$delegate) {
        Lazy<PreferencesManager> lazy = $preferencesManager$delegate;
        return (PreferencesManager)lazy.getValue();
    }

    public static final /* synthetic */ boolean access$isOverrideNetworkType5G(TelephonyDisplayInfo telephonyDisplayInfo) {
        return FunctionsKt.isOverrideNetworkType5G(telephonyDisplayInfo);
    }
}

