/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.c1o.sdk.framework;

import android.app.ActivityManager;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.PowerManager;
import android.os.StatFs;
import com.calldorado.c1o.sdk.framework.TUc4;
import com.calldorado.c1o.sdk.framework.TUe9;
import com.calldorado.c1o.sdk.framework.TUk7;
import com.calldorado.c1o.sdk.framework.TUkk;
import com.calldorado.c1o.sdk.framework.TUl6;
import com.calldorado.c1o.sdk.framework.TUm2;
import com.calldorado.c1o.sdk.framework.TUz3;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TUu1 {
    private static final String a = "TUDeviceMetrics";
    private static final String JW = "MEMORY_USED";
    static final String JX = "MEMORY_FREE";
    static final String JY = "MEMORY_TOTAL";
    static final String JZ = "BATTERY_LEVEL";
    static final String Ka = "BATTERY_STATE";
    static final String eA = "BATTERY_TEMPERATURE";
    static final Long Kb = 100L * (long)TUk7.Tz;
    private static boolean Kc = true;
    private static final long Kd = 20000000L;
    private static final long Ke = 600000L;
    protected static long Kf = 0L;

    TUu1() {
    }

    protected static Bundle bn(Context cont) {
        long total_memory = TUc4.wg();
        long free_memory = TUc4.wg();
        long used_memory = TUc4.wg();
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                ActivityManager actManager = (ActivityManager)cont.getSystemService("activity");
                if (actManager != null) {
                    ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
                    actManager.getMemoryInfo(memInfo);
                    total_memory = memInfo.totalMem;
                    free_memory = memInfo.availMem;
                    used_memory = total_memory - free_memory;
                }
            }
            catch (Exception e) {
                TUz3.b(TUm2.Dl.Do, a, "getDeviceMemory failed: " + e.getMessage(), e);
            }
        }
        Bundle mBundle = new Bundle();
        mBundle.putLong(JX, free_memory);
        mBundle.putLong(JW, used_memory);
        mBundle.putLong(JY, TUu1.aL(total_memory));
        return mBundle;
    }

    protected static long pN() {
        try {
            return TUu1.pP().longValue();
        }
        catch (Exception e) {
            TUz3.b(TUm2.Dl.Do, a, e.getMessage(), e);
            return TUc4.wg();
        }
    }

    static String pO() {
        try {
            double totalMem = TUu1.pP();
            return TUu1.E(totalMem);
        }
        catch (Exception e) {
            TUz3.b(TUm2.Dl.Do, a, e.getMessage(), e);
            return null;
        }
    }

    private static String E(double totRam) {
        if (totRam == (double)TUc4.wg()) {
            return null;
        }
        String lastValue = null;
        try {
            DecimalFormat twoDecimalForm = new DecimalFormat("#.##");
            double mb = totRam / 1024.0;
            double gb = totRam / 1048576.0;
            double tb = totRam / 1.073741824E9;
            lastValue = tb > 1.0 ? twoDecimalForm.format(tb).concat(" TB") : (gb > 1.0 ? twoDecimalForm.format(gb).concat(" GB") : (mb > 1.0 ? twoDecimalForm.format(mb).concat(" MB") : twoDecimalForm.format(totRam).concat(" KB")));
        }
        catch (Exception e) {
            TUz3.b(TUm2.Dl.Do, a, e.getMessage(), e);
        }
        return lastValue;
    }

    private static Double pP() {
        RandomAccessFile reader = null;
        double totRam = TUc4.wg();
        try {
            reader = new RandomAccessFile("/proc/meminfo", "r");
            String load = reader.readLine();
            reader.close();
            Pattern p = Pattern.compile("(\\d+)");
            Matcher m = p.matcher(load);
            String value = "";
            while (m.find()) {
                value = m.group(1);
            }
            totRam = Double.parseDouble(value);
        }
        catch (Exception ex) {
            TUz3.b(TUm2.Dl.Do, a, ex.getMessage(), ex);
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                TUz3.b(TUm2.Dm.Do, a, e1.getMessage(), e1);
            }
        }
        return totRam;
    }

    protected static double pQ() {
        if (!Kc) {
            return TUc4.wg();
        }
        RandomAccessFile reader = null;
        try {
            reader = new RandomAccessFile("/proc/stat", "r");
            String load = reader.readLine();
            String[] toks = load.split(" +");
            long idle1 = Long.parseLong(toks[4]);
            long cpu1 = Long.parseLong(toks[1]) + Long.parseLong(toks[2]) + Long.parseLong(toks[3]) + Long.parseLong(toks[5]) + Long.parseLong(toks[6]) + Long.parseLong(toks[7]);
            Thread.sleep(360L);
            reader.seek(0L);
            load = reader.readLine();
            reader.close();
            toks = load.split(" +");
            long idle2 = Long.parseLong(toks[4]);
            long cpu2 = Long.parseLong(toks[1]) + Long.parseLong(toks[2]) + Long.parseLong(toks[3]) + Long.parseLong(toks[5]) + Long.parseLong(toks[6]) + Long.parseLong(toks[7]);
            double result = (double)(cpu2 - cpu1) / (double)(cpu2 + idle2 - (cpu1 + idle1));
            if (result < 0.0 || result > 1.0 || Double.isNaN(result) || Double.isInfinite(result)) {
                return TUc4.wg();
            }
            BigDecimal bigDecimal = BigDecimal.valueOf(result);
            return bigDecimal.setScale(2, 4).doubleValue();
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                Kc = false;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                TUz3.b(TUm2.Dm.Do, a, e1.getMessage(), e1);
            }
            TUz3.b(TUm2.Dl.Do, a, e.getMessage(), e);
            return TUc4.wg();
        }
    }

    protected static boolean a(boolean fromStart, long currentTimeInMillis) {
        long internalDataFree = -1L;
        if (fromStart || Kf == 0L || currentTimeInMillis > Kf + 600000L) {
            Kf = currentTimeInMillis;
            try {
                internalDataFree = TUu1.aJ(Environment.getDataDirectory().toString());
            }
            catch (Exception e) {
                TUz3.b(TUm2.Dl.Do, a, "Cannot validate sufficient data storage space: " + e.getMessage(), e);
            }
            if (internalDataFree != -1L && internalDataFree < 20000000L) {
                TUz3.b(TUm2.Dl.Do, a, "Low data storage space to safely run SDK: " + internalDataFree + ", Req:" + 20000000L, null);
                return false;
            }
        }
        return true;
    }

    static long[] bo(Context cont) {
        long internalDataTotal = 0L;
        long internalSDTotal = 0L;
        long internalDataFree = 0L;
        long internalSDFree = 0L;
        long totalMemory = 0L;
        long freeMemory = 0L;
        List<String> listStorage = null;
        try {
            internalDataTotal = TUu1.aI(Environment.getDataDirectory().toString());
            internalDataFree = TUu1.aJ(Environment.getDataDirectory().toString());
        }
        catch (Exception e) {
            TUz3.b(TUm2.Dl.Do, a, "Internal data storage not accessible: " + e.getMessage(), e);
        }
        boolean hasPermission = TUkk.bZ(cont);
        if (hasPermission) {
            try {
                listStorage = TUu1.pR();
            }
            catch (Exception e) {
                TUz3.b(TUm2.Dl.Do, a, "Accessing proc/mounts failed: " + e.getMessage(), e);
            }
            try {
                if (Build.VERSION.SDK_INT >= 21) {
                    if (!Environment.isExternalStorageEmulated()) {
                        internalSDTotal = TUu1.aI(Environment.getExternalStorageDirectory().getAbsolutePath());
                        internalSDFree = TUu1.aJ(Environment.getExternalStorageDirectory().getAbsolutePath());
                    }
                } else if (!Environment.getExternalStorageDirectory().getAbsoluteFile().toString().contains("emulated")) {
                    internalSDTotal = TUu1.aI(Environment.getExternalStorageDirectory().getAbsolutePath());
                    internalSDFree = TUu1.aJ(Environment.getExternalStorageDirectory().getAbsolutePath());
                }
            }
            catch (Exception e) {
                TUz3.b(TUm2.Dl.Do, a, "Getting primary storage size failed: " + e.getMessage(), e);
            }
            totalMemory = internalSDTotal;
            freeMemory = internalSDFree;
            if (listStorage != null && listStorage.size() != 0) {
                for (String path : listStorage) {
                    try {
                        totalMemory += TUu1.aI(path);
                        freeMemory += TUu1.aJ(path);
                    }
                    catch (Exception ex) {
                        TUz3.b(TUm2.Dl.Do, a, "External SD card path not accessible: " + ex.getMessage(), ex);
                    }
                }
            }
        }
        totalMemory = internalDataTotal + totalMemory;
        if ((freeMemory = internalDataFree + freeMemory) == 0L) {
            freeMemory = TUc4.wg();
        }
        if (totalMemory == 0L) {
            totalMemory = TUc4.wg();
        }
        return new long[]{TUu1.aL(totalMemory), freeMemory};
    }

    protected static long aL(long totalMemory) {
        if (totalMemory == 0L) {
            return totalMemory;
        }
        if (totalMemory == (long)TUc4.wg() || totalMemory == (long)TUc4.wh()) {
            return totalMemory;
        }
        try {
            return (totalMemory + Kb / 2L) / Kb * Kb;
        }
        catch (Exception exception) {
            return totalMemory;
        }
    }

    private static List<String> pR() throws Exception {
        ArrayList<String> sdPathList = new ArrayList<String>();
        File mountList = new File("/proc/mounts");
        BufferedReader reader = null;
        try {
            if (mountList.exists()) {
                String line;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(mountList), "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    String[] lineSplits;
                    String sdPath;
                    if (!line.contains(" /storage/") || (sdPath = (lineSplits = line.split(" "))[1]).equals(Environment.getExternalStorageDirectory().getAbsolutePath()) || sdPath.contains("emulated") || sdPath.contains("self") || sdPathList.contains(sdPath)) continue;
                    sdPathList.add(sdPath);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e1) {
                TUz3.b(TUm2.Dm.Do, a, "Exception while closing BufferedReader.", null);
            }
        }
        return sdPathList;
    }

    private static long aI(String path) {
        long total = 0L;
        if (new File(path).isDirectory()) {
            StatFs statFs = new StatFs(path);
            total = Build.VERSION.SDK_INT > 17 ? statFs.getBlockCountLong() * statFs.getBlockSizeLong() : (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
        }
        return total;
    }

    private static long aJ(String path) {
        long free = 0L;
        if (new File(path).isDirectory()) {
            StatFs statFs = new StatFs(path);
            free = Build.VERSION.SDK_INT > 17 ? statFs.getAvailableBlocksLong() * statFs.getBlockSizeLong() : (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
        }
        return free;
    }

    static int bp(Context context) {
        int dozeState = 1;
        if (Build.VERSION.SDK_INT > 22) {
            try {
                PowerManager powerManager = (PowerManager)context.getSystemService("power");
                dozeState = powerManager == null ? 0 : (powerManager.isDeviceIdleMode() ? 3 : 2);
            }
            catch (Exception e) {
                dozeState = 0;
                TUz3.b(TUm2.Dk.Do, a, "Ex in getDozeState method", e);
            }
        }
        return dozeState;
    }

    static int bq(Context context) {
        int networkRestriction = 1;
        try {
            ConnectivityManager connectivityManager;
            if (Build.VERSION.SDK_INT >= 21) {
                networkRestriction = 0;
                PowerManager powerManager = (PowerManager)context.getSystemService("power");
                if (powerManager != null) {
                    int n = networkRestriction = powerManager.isPowerSaveMode() ? 2 : 1;
                }
            }
            if (Build.VERSION.SDK_INT > 23 && (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")) != null && connectivityManager.isActiveNetworkMetered() && connectivityManager.getRestrictBackgroundStatus() == 3) {
                networkRestriction = networkRestriction == 2 ? 4 : 3;
            }
        }
        catch (Exception e) {
            TUz3.b(TUm2.Dk.Do, a, "Ex in getNetworkRestrictions method", e);
            networkRestriction = 0;
        }
        return networkRestriction;
    }

    static int br(Context context) {
        int userInteraction = 0;
        try {
            UsageStatsManager usageStatsManager;
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            if (powerManager != null) {
                if (Build.VERSION.SDK_INT > 19) {
                    userInteraction = powerManager.isInteractive() ? 1 : 2;
                } else {
                    int n = userInteraction = powerManager.isScreenOn() ? 1 : 2;
                }
            }
            if (Build.VERSION.SDK_INT > 22 && (usageStatsManager = (UsageStatsManager)context.getSystemService("usagestats")) != null) {
                if (userInteraction == 1) {
                    userInteraction = usageStatsManager.isAppInactive(context.getPackageName()) ? 3 : userInteraction;
                } else if (userInteraction == 2) {
                    userInteraction = usageStatsManager.isAppInactive(context.getPackageName()) ? 4 : userInteraction;
                }
            }
        }
        catch (Exception e) {
            TUz3.b(TUm2.Dk.Do, a, "Ex in getUserInteraction method", e);
        }
        return userInteraction;
    }

    static Bundle bs(Context context) {
        Bundle resultBundle = new Bundle();
        try {
            Intent batteryResult = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            if (batteryResult == null) {
                return resultBundle;
            }
            int level = batteryResult.getIntExtra("level", TUc4.wg());
            int scale = batteryResult.getIntExtra("scale", TUc4.wg());
            int status = batteryResult.getIntExtra("status", TUc4.wg());
            int temperature = batteryResult.getIntExtra("temperature", TUc4.wg());
            double batteryPercent = (float)level / (float)scale;
            resultBundle.putDouble(JZ, batteryPercent);
            resultBundle.putInt(eA, temperature);
            if (status == TUc4.wg()) {
                status = 1;
            }
            if (status == 1) {
                status = TUe9.Jz.gQ();
            } else if (status == 2) {
                status = TUe9.JA.gQ();
            } else if (status == 3) {
                status = TUe9.JB.gQ();
            } else if (status == 4) {
                status = TUe9.JC.gQ();
            } else if (status == 5) {
                status = TUe9.JD.gQ();
            }
            resultBundle.putInt(Ka, status);
        }
        catch (Exception e) {
            TUz3.b(TUm2.Dl.Do, a, "Err retrieving battery level, status & temperature", e);
        }
        return resultBundle;
    }

    static int bt(Context context) {
        if (Build.VERSION.SDK_INT < 23) {
            return TUl6.TUv2.LC.gQ();
        }
        try {
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            if (powerManager == null) {
                return TUl6.TUv2.LD.gQ();
            }
            return powerManager.isIgnoringBatteryOptimizations(context.getPackageName()) ? TUl6.TUv2.LE.gQ() : TUl6.TUv2.LF.gQ();
        }
        catch (Exception e) {
            TUz3.b(TUm2.Dk.Do, a, "Ex in isIgnoringBatteryOptimization method", e);
            return TUl6.TUv2.LD.gQ();
        }
    }
}

