/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.c1o.sdk.framework;

import android.annotation.SuppressLint;
import android.app.ApplicationExitInfo;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.calldorado.c1o.sdk.framework.AnaSDKService;
import com.calldorado.c1o.sdk.framework.TUc4;
import com.calldorado.c1o.sdk.framework.TUm2;
import com.calldorado.c1o.sdk.framework.TUz3;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;

@RequiresApi(value=30)
class TUx2 {
    private static final String CN = "TUApplicationExitInfoV2";
    private static final String CO = "ANR_TIMESTAMPS_PREF_KEY";
    static final String a = "TUApplicationExitInfo";
    static final String CP = "REASON_UNKNOWN";
    static final String CQ = "REASON_EXIT_SELF";
    static final String CR = "REASON_SIGNALED";
    static final String CS = "REASON_LOW_MEMORY";
    static final String CT = "REASON_CRASH";
    static final String CU = "REASON_CRASH_NATIVE";
    static final String CV = "REASON_ANR";
    static final String CW = "REASON_INITIALIZATION_FAILURE";
    static final String CX = "REASON_PERMISSION_CHANGE";
    static final String CY = "REASON_EXCESSIVE_RESOURCE_USAGE";
    static final String CZ = "REASON_USER_REQUESTED";
    static final String Da = "REASON_USER_STOPPED";
    static final String Db = "REASON_DEPENDENCY_DIED";
    static final String Dc = "REASON_OTHER";
    private String Dd = TUc4.wj();
    private int De = TUc4.wh();
    private int Df = TUc4.wh();
    private String Dg = TUc4.wj();
    private long Dh = TUc4.wh();
    private int Di = TUc4.wh();
    private long uJ = TUc4.wh();
    private String Dj = TUc4.wj();

    static String mv() {
        return CN;
    }

    @SuppressLint(value={"WrongConstant"})
    TUx2(ApplicationExitInfo exitInfo) {
        if (exitInfo.getDescription() != null) {
            this.Dd = exitInfo.getDescription();
        }
        this.De = exitInfo.getImportance();
        this.Df = exitInfo.getPackageUid();
        this.Dg = exitInfo.getProcessName();
        if (exitInfo.getPss() > 0L) {
            this.Dh = exitInfo.getPss();
        }
        this.Di = exitInfo.getReason();
        this.uJ = exitInfo.getTimestamp();
        try (InputStream traceInputStream = exitInfo.getTraceInputStream();){
            if (traceInputStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(traceInputStream));
                StringBuilder trace = new StringBuilder();
                String nextLine = reader.readLine();
                while (nextLine != null) {
                    trace.append(nextLine);
                    nextLine = reader.readLine();
                }
                this.Dj = trace.toString();
            }
        }
        catch (IOException e) {
            this.Dj = TUc4.wi();
            TUz3.b(TUm2.Dl.Do, a, "IOException reading trace stream: " + e.getMessage(), e);
        }
    }

    @NonNull
    public String toString() {
        JSONObject json = new JSONObject();
        try {
            json.put("description", (Object)this.Dd);
            json.put("importance", (Object)this.mw());
            json.put("packageUid", this.Df);
            json.put("processName", (Object)this.Dg);
            json.put("pss", this.Dh);
            json.put("reason", (Object)this.mx());
            json.put("timestamp", this.uJ);
            json.put("trace", (Object)this.Dj);
        }
        catch (JSONException e) {
            TUz3.b(TUm2.Dl.Do, a, "Failed to serialize: " + e.getMessage(), (Exception)((Object)e));
        }
        return json.toString();
    }

    long kG() {
        return this.uJ;
    }

    String mw() {
        switch (this.De) {
            case 100: {
                return "IMPORTANCE_FOREGROUND";
            }
            case 125: {
                return "IMPORTANCE_FOREGROUND_SERVICE";
            }
            case 150: 
            case 325: {
                return "IMPORTANCE_TOP_SLEEPING";
            }
            case 200: {
                return "IMPORTANCE_VISIBLE";
            }
            case 130: 
            case 230: {
                return "IMPORTANCE_PERCEPTIBLE";
            }
            case 350: {
                return "IMPORTANCE_CANT_SAVE_STATE";
            }
            case 300: {
                return "IMPORTANCE_SERVICE";
            }
            case 400: {
                return "IMPORTANCE_CACHED";
            }
            case 1000: {
                return "IMPORTANCE_GONE";
            }
            case 500: {
                return "IMPORTANCE_EMPTY";
            }
        }
        return String.valueOf(this.De);
    }

    String mx() {
        switch (this.Di) {
            case 0: {
                return CP;
            }
            case 1: {
                return CQ;
            }
            case 2: {
                return CR;
            }
            case 3: {
                return CS;
            }
            case 4: {
                return CT;
            }
            case 5: {
                return CU;
            }
            case 6: {
                return CV;
            }
            case 7: {
                return CW;
            }
            case 8: {
                return CX;
            }
            case 9: {
                return CY;
            }
            case 10: {
                return CZ;
            }
            case 11: {
                return Da;
            }
            case 12: {
                return Db;
            }
            case 13: {
                return Dc;
            }
        }
        return String.valueOf(this.Di);
    }

    boolean my() {
        return !this.Dj.equals(TUc4.wj()) && !this.Dj.equals(TUc4.wi());
    }

    boolean mz() {
        String serviceClass = "";
        try {
            serviceClass = AnaSDKService.class.getName();
            String packageDomain = serviceClass.substring(0, serviceClass.indexOf(46, 4));
            return this.Dj.contains(packageDomain);
        }
        catch (Exception e) {
            TUz3.b(TUm2.Dk.Dp, a, "Programming error - wrong service class name: " + serviceClass + " Exception: " + e.getMessage(), e);
            return false;
        }
    }

    String mA() {
        return this.Dj;
    }

    static ArrayList<Long> ai(Context context) {
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            SharedPreferences preferences = context.getSharedPreferences(CN, 0);
            String anrs = preferences.getString(CO, "");
            StringTokenizer st = new StringTokenizer(anrs, ",");
            while (st.hasMoreTokens()) {
                result.add(Long.parseLong(st.nextToken()));
            }
        }
        catch (Exception e) {
            TUz3.b(TUm2.Dl.Do, a, "Exception reading ANR prefs: " + e.getMessage(), e);
        }
        return result;
    }

    static void a(Context context, ArrayList<Long> anrTimestamps) {
        try {
            SharedPreferences preferences = context.getSharedPreferences(CN, 0);
            StringBuilder builder = new StringBuilder();
            String prefix = "";
            for (Long timestamp : anrTimestamps) {
                builder.append(prefix).append(timestamp);
                prefix = ",";
            }
            preferences.edit().putString(CO, builder.toString()).apply();
        }
        catch (Exception e) {
            TUz3.b(TUm2.Dl.Do, a, "Exception writing ANR prefs: " + e.getMessage(), e);
        }
    }
}

