/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.lint.checks;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.calldorado.lint.checks.AutoGenRiskyDeps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\t\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003JJ\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J4\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/calldorado/lint/checks/LibrariesVersionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$GradleScanner;", "()V", "checkDslPropertyAssignment", "", "context", "Lcom/android/tools/lint/detector/api/GradleContext;", "property", "", "value", "parent", "parentParent", "propertyCookie", "", "valueCookie", "statementCookie", "reportIncompatibility", "message", "cookie", "currentVersion", "versionToUse", "Companion", "lint-checks"})
public final class LibrariesVersionDetector
extends Detector
implements Detector.GradleScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String incompatibleVersionMessage = "The library version you are using may not be fully compatible with CDO SDK, results may be unstable, please use version: ";
    @NotNull
    public static final String interpolatedVersionStringMessage = "Please use the version number directly instead of interpolated strings";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(LibrariesVersionDetector.class, Scope.GRADLE_SCOPE);
    @NotNull
    private static final Issue ISSUE;
    @NotNull
    private static final HashMap<String, String> depMap;

    public void checkDslPropertyAssignment(@NotNull GradleContext context, @NotNull String property, @NotNull String value, @NotNull String parent, @Nullable String parentParent, @NotNull Object propertyCookie, @NotNull Object valueCookie, @NotNull Object statementCookie) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)propertyCookie, (String)"propertyCookie");
        Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
        Intrinsics.checkNotNullParameter((Object)statementCookie, (String)"statementCookie");
        super.checkDslPropertyAssignment(context, property, value, parent, parentParent, propertyCookie, valueCookie, statementCookie);
        if (Intrinsics.areEqual((Object)parent, (Object)"dependencies")) {
            String string = GradleContext.Companion.getStringLiteralValue(value);
            if (string == null && (string = GradleDetector.Companion.getNamedDependency(value)) == null) {
                return;
            }
            String dependency = string;
            GradleCoordinate gradleCoordinate = GradleCoordinate.parseCoordinateString((String)dependency);
            if (gradleCoordinate == null) {
                return;
            }
            GradleCoordinate gc = gradleCoordinate;
            GradleVersion version = gc.getVersion();
            Map $this$forEach$iv = depMap;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)dependency, (CharSequence)((CharSequence)entry.getKey()), (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)dependency, (CharSequence)"$", (boolean)false, (int)2, null) && version.compareTo((String)entry.getValue()) <= 0) continue;
                this.reportIncompatibility(context, StringsKt.contains$default((CharSequence)dependency, (CharSequence)"$", (boolean)false, (int)2, null) ? interpolatedVersionStringMessage : incompatibleVersionMessage + (String)entry.getValue(), statementCookie, version.toString(), (String)entry.getValue());
            }
        }
    }

    private final void reportIncompatibility(GradleContext context, String message, Object cookie, String currentVersion, String versionToUse) {
        context.report(ISSUE, cookie, context.getLocation(cookie), message, this.fix().replace().pattern(currentVersion).with(versionToUse).reformat(true).build());
    }

    static {
        String string = LibrariesVersionDetector.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LibrariesVersionDetector::class.java.simpleName");
        ISSUE = Issue.Companion.create(string, "Possible incompatible target library versions", incompatibleVersionMessage, Category.CORRECTNESS, 10, Severity.FATAL, IMPLEMENTATION);
        HashMap hashMap = AutoGenRiskyDeps.getDependencyMap();
        Intrinsics.checkNotNull((Object)hashMap, (String)"null cannot be cast to non-null type java.util.HashMap<kotlin.String, kotlin.String>{ kotlin.collections.TypeAliasesKt.HashMap<kotlin.String, kotlin.String> }");
        depMap = hashMap;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR-\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/calldorado/lint/checks/LibrariesVersionDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "depMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getDepMap", "()Ljava/util/HashMap;", "incompatibleVersionMessage", "interpolatedVersionStringMessage", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        @NotNull
        public final HashMap<String, String> getDepMap() {
            return depMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

